IF OBJECT_ID('V_PDV_CX_CARGA_PDV') IS NOT NULL
BEGIN
	DROP VIEW V_PDV_CX_CARGA_PDV;
END

GO
CREATE VIEW V_PDV_CX_CARGA_PDV
AS
SELECT
	CX.CD_EMP,
	CX.CD_FILIAL,
	CX.NM_TERM,
	CX.CD_CX,
	CX.PORTA_IMP,
	CX.PORTA_BLNC,
	CX.VEL_COM_BLNC,
	CX.END_ORC,
	CX.STS_PDV,
	CX.MDL_IMP_FC,
	CX.NR_SERIE_IMP,
	ISNULL(CX.ID_TERM_TEF,'') AS ID_TERM_TEF,
	CX.VLR_INI_LACR,
	ISNULL(CX.TIPO_ECF,'') AS TIPO_ECF,
	ISNULL(CX.MARCA_ECF,'') AS MARCA_ECF,
	ISNULL(CX.MODELO_ECF,'') AS MODELO_ECF,
	CX.EXPORT,
	CX.DT_INI,
	CX.DT_FIM,
	CX.FLAG_NFCE,
	CX.CD_CTR_SERIE,
	CX.VERSAO_SOFTWARE_BASICO,
	CX.DATA_GRAVACAO_SOFTWARE_BASICO,
	CX.HORA_GRAVACAO_SOFTWARE_BASICO,
	CX.NR_PROPIETARIO_ECF,
	CX.FLAG_DESCONTO_ISS,
	CX.CODIGO_NACIONAL_IDENTIFICACAO_ECF,
	CX.REG_ALTERADO,		
	ISNULL(SERIE.SERIE,0)  AS CD_NF_SERIE,
	ISNULL(CX.UTIL_GAV,0)  AS UTIL_GAV,
	ISNULL(CX.UTIL_BLNC,0) AS UTIL_BLNC
	
FROM	PDV_CX	CX
LEFT JOIN PDV_CX_EST_NF_SERIE CX_SERIE
ON		CX.CD_CTR_SERIE = CX_SERIE.CD_CTR		
LEFT JOIN EST_NF_SERIE SERIE
ON		CX_SERIE.CD_EMP = SERIE.CD_EMP
AND		CX_SERIE.CD_NF_SERIE = SERIE.CD_NF_SERIE
AND     (SERIE.TP_SR_NFE = 1) 
AND (SERIE.COD_MODELO = '65') 
AND (SERIE.ESPC = 'NFE')
